/**
* \file: am_api_mutex.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AM_API_MUTEX_H
#define AM_API_MUTEX_H

#include <automounter_types.h>

void am_api_mutex_entering_library(void);

void am_api_mutex_leaving_library(void);

/**
 * Used to lock the dispatcher mutex. This function checks before locking the mutex if the calling thread locked the
 * mutex before. In this case, the function returns RESULT_INVALID. Otherwise, RESULT_OK is returned once the
 * mutex is locked.
 */
error_code_t am_api_mutex_entering_event_dispatcher(void);

void am_api_mutex_leaving_event_dispatcher(void);

#endif
